<html>
<head>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.10/css/select2.min.css">
</head>
<body>
    <div>
        <select style="width:250px;" class="select2-ajax"></select>
    </div>
    <script src="https://code.jquery.com/jquery-3.4.1.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.10/js/select2.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.10/js/i18n/ja.js"></script>
    <script>

        $(() => {

            $('.select2-ajax').select2({
                ajax: {
                    url: '/ajax/user',
                    dataType: 'json',
                    processResults(response) {  // データをselect2向けに加工

                        let options = [];

                        response.data.forEach((user) => {

                            options.push({
                                id: user.id,
                                text: user.name
                            });

                        });

                        return {
                            results: options,
                            pagination: {
                                more: (response.next_page_url !== null)  // 次ページがあるかどうか
                            }
                        };

                    }
                },
                allowClear: true,
                placeholder: '',
                language: 'ja'
            });

        });

    </script>
</body>
</html>
