(define (FU-simple-draw-line
        img
        current-layer
        color
        steps
        rounded-corner)

    (if (= (car (gimp-selection-is-empty img)) FALSE)
      (begin
        (if (> rounded-corner 0)
          (script-fu-selection-rounded-rectangle img current-layer rounded-corner FALSE)
        )
        (gimp-palette-set-foreground color)
        (gimp-edit-fill current-layer FOREGROUND-FILL)
        (gimp-selection-shrink img steps)
        (gimp-edit-clear current-layer)
        (gimp-displays-flush)
        (gimp-selection-none img)
      ); End begin
      (gimp-message "Select area to draw a line!")
    )

)
(script-fu-register "FU-simple-draw-line"
    "<Image>/Script-Fu/simple-draw-line"
    "Draw a line"
    "Sukohi Kuhoh"
    "Sukohi Kuhoh"
    "2019"
    "*"
    SF-IMAGE    "Image"         0
    SF-DRAWABLE "Current Layer" 0
    SF-COLOR "Color" '(0 0 0)
    SF-ADJUSTMENT "Steps" '(5 1 50 1 10 0 0)
    SF-ADJUSTMENT "Rounded corner" '(0 0 100 1 10 0 0)
)
