<html>
<body>
    <div id="app">
        <h5>画像を選択してください</h5>
        <input type="file" accept="image/*" @change="onImageChange">
        <hr>
        <div style="float:right;">
            <div v-if="status=='select_points'">
                以下の順で修正後の角４つをクリックしてください。
                <ul>
                    <li>&#x2196;左上</li>
                    <li>&#x2197;右上</li>
                    <li>&#x2198;右下</li>
                    <li>&#x2199;左下</li>
                </ul>
            </div>
            <div v-if="status=='prepared'">
                角４つの選択が完了しました。
                <ul>
                    <li v-for="point in selectedPoints">
                        （x, y）＝（
                        <span v-text="point.x"></span>,
                        <span v-text="point.y"></span>
                        ）
                    </li>
                </ul>
                <button type="button" @click="reselect">やり直す</button>
                <button type="button" @click="transform">送信する</button>
            </div>
        </div>
        <canvas ref="canvas" @click="onImageClick"></canvas>
    </div>
    <script src="https://cdn.jsdelivr.net/npm/vue@2.6.10/dist/vue.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/axios/0.19.0/axios.min.js"></script>
    <script>

        new Vue({
            el: '#app',
            data: {
                file: null,
                status: 'upload',
                selectedPoints: [],
                imageData: null
            },
            methods: {
                onImageChange(e) {

                    this.selectedPoints = [];
                    this.status = 'select_points';
                    this.file = e.target.files[0];
                    this.renderImage();

                },
                onImageClick(e) {

                    if(this.selectedPoints.length < 4) {

                        const x = Math.round(e.offsetX / this.canvas.width * 1000) / 1000;
                        const y = Math.round(e.offsetY / this.canvas.height * 1000) / 1000;
                        const position = {
                            x: x,
                            y: y
                        };
                        this.selectedPoints.push(position);
                        this.drawPoint(position);

                    }

                },
                drawPoint(position) {

                    const r = parseInt(this.canvas.height / 50);
                    const x = Math.round(position.x * this.canvas.width);
                    const y = Math.round(position.y * this.canvas.height);
                    this.context.beginPath();
                    this.context.arc(x, y, r, 0, 2 * Math.PI);
                    this.context.fillStyle = 'red';
                    this.context.fill();

                    if(this.selectedPoints.length === 4) {

                        this.status = 'prepared';

                    }

                },
                transform() {

                    const url = '/perspective_transform/transform';
                    let formData = new FormData();

                    for(let i = 0 ; i < this.selectedPoints.length ; i++) {

                        let x = this.selectedPoints[i]['x'];
                        let y = this.selectedPoints[i]['y'];
                        formData.append('selected_points['+ i +'][x]', x);
                        formData.append('selected_points['+ i +'][y]', y);

                    }

                    formData.append('image', this.imageData);
                    axios.post(url, formData)
                        .then((response) => {

                            if(response.data.result) {

                                location.href = '/perspective_transform/download';

                            }

                        });

                },
                reselect() {

                    this.status = 'select_points';
                    this.selectedPoints = [];
                    this.renderImage();

                },
                renderImage() {

                    let reader = new FileReader();
                    reader.readAsDataURL(this.file);
                    reader.onload = (e) => {

                        let img = new Image();
                        img.onload = () => {

                            // キャンバスに描画
                            const width = img.width;
                            const height = img.height;

                            this.canvas.width = width;
                            this.canvas.height = height;
                            this.context.drawImage(img, 0, 0, width, height);

                            // 画像データを格納
                            this.context.canvas.toBlob((blob) => {

                                this.imageData = blob;

                            }, this.file.type, 1);

                        };
                        img.src = e.target.result;

                    };

                }
            },
            computed: {
                canvas() {

                    return this.$refs['canvas'];

                },
                context() {

                    return this.canvas.getContext('2d');

                }
            }
        });

    </script>
</body>
</html>