<html>
<head>
    <link href="https://stackpath.bootstrapcdn.com/bootstrap/4.3.1/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>
<div id="app">
    <canvas id="canvas" @click="openModal"></canvas>
    <br>
    <ul>
        <li v-for="book in books">
            <a href="#" v-text="book.title" @click.prevent="showBookPosition(book)"></a>
        </li>
    </ul>
    <!-- モーダル -->
    <div class="modal fade" id="modal">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">本のタイトルを入力してください</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <input type="text" class="form-control" v-model="bookTitle" autofocus>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-light" data-dismiss="modal">キャンセル</button>
                    <button type="button" class="btn btn-primary" data-dismiss="modal" @click="save">保存する</button>
                </div>
            </div>
        </div>
    </div>
</div>
<script src="https://cdn.jsdelivr.net/npm/vue@2.6.10/dist/vue.min.js"></script>
<script src="https://code.jquery.com/jquery-3.4.1.min.js"></script>
<script src="https://stackpath.bootstrapcdn.com/bootstrap/4.3.1/js/bootstrap.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/axios/0.19.0/axios.min.js"></script>
<script>

    new Vue({
        el: '#app',
        data: {
            canvas: null,
            ctx: null,
            books: [],
            position: {
                x: 0,
                y: 0
            },
            bookTitle: ''
        },
        methods: {
            openModal(e) {

                this.clearCanvas(() => {

                    const x = Math.round(e.offsetX / this.canvas.width * 1000) * 0.001;
                    const y = Math.round(e.offsetY / this.canvas.height * 1000) * 0.001;
                    this.position = {
                        x: x,
                        y: y
                    };
                    this.drawPoint('red');
                    this.bookTitle = '';
                    $('#modal').modal('show');

                });

            },
            save() {

                const params = {
                    title: this.bookTitle,
                    position: this.position
                };

                axios.post('/internet_cafe/store', params)
                    .then((response) => {

                        this.getBooks();

                    });

                $('#modal').modal('hide');

            },
            getBooks() {

                axios.get('/internet_cafe/index')
                    .then((response) => {

                        this.books = response.data;

                    });

            },
            showBookPosition(book) {

                this.position = {
                    x: parseFloat(book.position_x),
                    y: parseFloat(book.position_y)
                };

                this.clearCanvas(() => {

                    this.drawPoint('orange');

                });

            },
            drawPoint(color) {

                const r = parseInt(canvas.height / 50);
                const x = Math.round(this.position.x * canvas.width);
                const y = Math.round(this.position.y * canvas.height);
                this.ctx.beginPath();
                this.ctx.arc(x, y, r, 0, 2 * Math.PI);
                this.ctx.fillStyle = color;
                this.ctx.fill();

            },
            clearCanvas(callback) {

                this.ctx.clearRect(0, 0, canvas.width, canvas.height);
                let img = new Image();
                img.src = '/images/room_layout.png';
                img.onload = () => {

                    canvas.width = img.width;
                    canvas.height = img.height;
                    this.ctx.drawImage(img, 0, 0);

                    if(typeof callback === 'function') {

                        callback();

                    }

                };

            }
        },
        mounted() {

            this.canvas = document.getElementById('canvas');
            this.ctx = canvas.getContext('2d');
            this.clearCanvas();
            this.getBooks();

            $('#modal').on('hide.bs.modal', () => {

                this.clearCanvas(() => {

                    this.getBooks();

                });

            });

            // おまけ
            document.onkeydown = (e) => {

                const key = e.key;
                const keys = ['ArrowUp', 'ArrowDown', 'ArrowLeft', 'ArrowRight'];

                if(keys.includes(key)) {

                    if(key === 'ArrowUp') {

                        this.position.y -= 0.001;

                    } else if(key === 'ArrowDown') {

                        this.position.y += 0.001;

                    } else if(key === 'ArrowLeft') {

                        this.position.x -= 0.001;

                    } else if(key === 'ArrowRight') {

                        this.position.x += 0.001;

                    }

                    this.clearCanvas(() => {

                        this.drawPoint('red');

                    });

                }

            };

        }

    });

</script>
</body>
</html>