<?php

namespace App\Http\Middleware;

use Carbon\Carbon;
use Closure;

class OnlyWednesday
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle($request, Closure $next)
    {
        $dt = new Carbon();

        if($dt->dayOfWeek !== 3) {

            abort('403', '水曜日のみ閲覧できます');

        }

        return $next($request);
    }
}
