(define (FU-simple-outline
        img
        drawable
        color
        thickness
        feather)

    (let* (
            (layer-name (car (gimp-item-get-name drawable)))
            (index (car (gimp-image-get-item-position img drawable)))
            (width (car (gimp-image-get-width img)))
            (height (car (gimp-image-get-height img)))
            (original-copied-layer (car (gimp-layer-copy drawable TRUE)))
            (outline-layer (car (gimp-layer-new img (string-append layer-name "(outline layer)") width height RGBA-IMAGE 100 LAYER-MODE-NORMAL-LEGACY)))
            (outline-group (car (gimp-group-layer-new img (string-append layer-name "(outline group)"))))
        )
        ; Make group and layer
        (gimp-image-insert-layer img outline-group 0 0)
        (gimp-image-insert-layer img outline-layer outline-group 0)
        (gimp-image-insert-layer img original-copied-layer outline-group 0)
        
        ; Selection
        (gimp-image-select-item img CHANNEL-OP-ADD drawable)
        (gimp-selection-grow img thickness)
        (gimp-selection-feather img feather)
        
        ; Draw
        (gimp-context-set-foreground color)
        (gimp-drawable-edit-fill outline-layer FILL-FOREGROUND)
        (gimp-selection-none img)
        
        ; Make the original layer transparent
        (gimp-image-select-item img CHANNEL-OP-ADD drawable)
    )

    (gimp-image-remove-layer img drawable)
    (gimp-displays-flush)
    (gimp-selection-none img)
)

(script-fu-register 
    "FU-simple-outline"
    "Simple outline"
    "Simple outline"
    "Sukohi Kuhoh"
    "Sukohi Kuhoh"
    "2025"
    "*"
    SF-IMAGE    "Image"         0
    SF-DRAWABLE "Current Layer" 0
    SF-COLOR "Color" '(0 0 0)
    SF-ADJUSTMENT "Thickness" '(4 1 50 1 10 0 0)
    SF-ADJUSTMENT "Feather" '(2 0 50 1 10 0 0)
)
(script-fu-menu-register "FU-simple-outline" "<Image>/Filters")
