#!/usr/bin/python
# -*- coding: utf-8 -*-

import cv2
import dlib
import numpy as np
import math

predictor_path = '/*****/model/shape_predictor_68_face_landmarks.dat'
detector = dlib.get_frontal_face_detector()
predictor = dlib.shape_predictor(predictor_path)

im = cv2.imread('/*****/images/family.jpg', cv2.IMREAD_COLOR)

if im is None:
    print('画像が見つかりません')
    exit()

rects = detector(im, 1)
if len(rects) == 0:
    print('顔が抽出されませんでした')
    exit()

def fitting_rotated_image(img, angle):
    height,width = img.shape[:2]
    center = (int(width/2), int(height/2))
    radians = np.deg2rad(angle)
    M = cv2.getRotationMatrix2D(center, angle, 1.0)

    new_width = int(abs(np.sin(radians)*height) + abs(np.cos(radians)*width))
    new_height = int(abs(np.sin(radians)*width) + abs(np.cos(radians)*height))

    M[0,2] += int((new_width-width)/2)
    M[1,2] += int((new_height-height)/2)

    return cv2.warpAffine(img, M, (new_width, new_height))

for index,rect in enumerate(rects):

    # 顔だけ切り出す
    rectWidth = rect.width()
    rectHeight = rect.height()
    rectCenter = rect.center()
    x_start = rectCenter.x - rectWidth
    x_end = x_start + rectWidth*2
    y_start = rectCenter.y - rectHeight
    y_end = y_start + rectHeight*2
    face_im = im[y_start:y_end, x_start:x_end]

    # 顔の角度を修正
    points = []
    for point in predictor(im, rect).parts():
        points.append([int(point.x), int(point.y)])
    x_diff = points[45][0] - points[36][0]
    y_diff = points[45][1] - points[36][1]
    angle = math.degrees(math.atan2(y_diff, x_diff))
    rotated_im = fitting_rotated_image(face_im, angle)
    cv2.imwrite('rotated_face_'+ str(index) +'.jpg', rotated_im)

    # 回転後の画像で顔検出して画像保存
    rotated_rects = detector(rotated_im, 1)
    if len(rotated_rects) == 0:
        print('顔が抽出されませんでした')
        continue

    rotated_rect = rotated_rects[0]
    x_start = rotated_rect.left()
    x_end = rotated_rect.right()
    y_start = rotated_rect.top()
    y_end = rotated_rect.bottom()
    cropped_im = rotated_im[y_start:y_end, x_start:x_end]
    cv2.imwrite('face_'+ str(index) +'.jpg', cropped_im)

    # 1.5倍のサイズにする
    # rotated_rect_center = rotated_rect.center()
    # x_start = int(rotated_rect_center.x - rotated_rect.width()*0.75)
    # x_end = int(x_start + rotated_rect.width()*1.5)
    # y_start = int(rotated_rect_center.y - rotated_rect.height()*0.75)
    # y_end = int(y_start + rotated_rect.height()*1.5)
    # cropped_im = rotated_im[y_start:y_end, x_start:x_end]
    # cv2.imwrite('face_lg_'+ str(index) +'.jpg', cropped_im)

