import React, { Component } from 'react';
import ReactDOM from 'react-dom';

export default class PreviewInput extends React.Component {

    constructor(props) {

        super(props)
        this.state = {
            imageData: null
        }
        this.fileInput = React.createRef()

    }

    resetInput() {

        this.fileInput.current.value = ''
        this.setState({ imageData: null })

    }

    onFileChange(e) {

        const files = e.target.files

        if(files.length > 0) {

            var file = files[0]
            var reader = new FileReader()
            reader.onload = (e) => {

                this.setState({ imageData: e.target.result })

            };
            reader.readAsDataURL(file)

        } else {

            this.setState({ imageData: null })

        }

    }

    render() {

        const imageData = this.state.imageData
        const fileInput= React.createRef()
        let preview = ''
        let resetButton = ''

        if(imageData != null) {

            preview = (
                <div>
                    <img src={imageData}/>
                </div>
            )

            resetButton = (
                <div>
                    <button type="button" onClick={this.resetInput.bind(this)}>リセットする</button>
                </div>
            )

        }

        return (
            <div>
                <input type="file" accept="image/*" ref={this.fileInput} onChange={
                    (e) => {
                        this.onFileChange(e)
                    }
                } />
                {preview}
                {resetButton}
            </div>
        )

    }

}

ReactDOM.render(
    <PreviewInput />,
    document.getElementById('preview-input')
);