Vue.component('v-image-checkbox', {
    props: {
        'true-image': {
            type: String,
            default: ''
        },
        'false-image': {
            type: String,
            default: ''
        },
        'value': {
            type: Boolean,
            default: false
        }
    },
    template: '<a href="#" @click.prevent="onClick()"><img style="border:1px solid #ccc;border-radius:5px;" :src="imageUrl"></a>',
    methods: {
        onClick: function() {

            this.value = !this.value;

        }
    },
    computed: {
        imageUrl: function() {

            return (this.value) ? this.trueImage : this.falseImage

        }
    },
    watch: {
        value: function(value) {

            this.$emit('input', value);

        }
    }
});