<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

class ImageController extends Controller
{
    public function email($code) {

        $email = decrypt($code); // メールアドレスを復号
        $path = storage_path('app/images/email/'. md5($email) .'.jpg');

        if(file_exists($path)) { // 2回目以降はここを通る

            $img = \Image::make($path);

        } else {

            \Image::configure(['driver' => 'imagick']); // ImageMagickを使う
            $width = 200;   // 画像の幅
            $height = 22;   // 画像の高さ
            $x = 5;
            $y = 5;
            $img = \Image::canvas($width, $height, '#ddd');
            $img->text($email, $x, $y, function($font) {
                $font->file(storage_path('app/fonts/ipagp.ttf')); // フォントを指定
                $font->size(18);      // テキストサイズ
                $font->align('left'); // 左揃え
                $font->valign('top'); // 上揃え
            });
            $img->save($path);

        }

        return $img->response();

    }

    public function smile(Request $request) {

        $email_opened_user = new \App\EmailOpenedUser();
        $email_opened_user->user_id = $request->user_id;
        $email_opened_user->save();

        $path = storage_path('app/images/smile.png');
        $image = \Image::make($path);
        return $image->response();

    }
}
